library(clusterProfiler)
library(topGO)
library(Rgraphviz)
library(pathview)
library(org.Hs.eg.db)
library(ggnewscale)
library(forcats)
library(ggplot2)
library(tidyverse)
args=commandArgs(T)
file <- args[1]
file1 <- args[2]
file2 <- args[3]
file3 <- args[4]
DEG.gene_symbol <- read.table(file,header = F)
DEG.gene_symbol <- as.character(unique(DEG.gene_symbol$V1))
DEG.entrez_id = mapIds(x = org.Hs.eg.db,keys = DEG.gene_symbol,keytype = "SYMBOL",column = "ENTREZID")
DEG.entrez_id = na.omit(DEG.entrez_id)
erich.go.BP = enrichGO(gene = DEG.entrez_id,OrgDb = org.Hs.eg.db,keyType = "ENTREZID",ont = "BP",pvalueCutoff = 0.05,qvalueCutoff = 0.05)
erich.go.CC = enrichGO(gene = DEG.entrez_id, OrgDb = org.Hs.eg.db, keyType = "ENTREZID",ont = "CC", pvalueCutoff = 0.05,qvalueCutoff = 0.05)
erich.go.MF =enrichGO(gene=DEG.entrez_id,OrgDb = org.Hs.eg.db,keyType = "ENTREZID",ont = "MF",pvalueCutoff = 0.05,qvalueCutoff = 0.05)
pdf(file1,width=8,height=8)
barplot(erich.go.MF,showCategory = 30,title = "GO_MF Terms")
dev.off()
KEGG <- enrichKEGG(gene = DEG.entrez_id,organism = 'hsa',keyType = 'kegg',pvalueCutoff = 0.05,qvalueCutoff = 0.05,pAdjustMethod = "BH")
pdf(file2,width=8,height=8)
dotplot(KEGG)
dev.off()

mf <- data.frame(erich.go.MF)
ke <- data.frame(KEGG)

a=1:62
for (i in a){
  num <- i
  tmp1 <- ke[num,8] %>% strsplit("/") %>% unlist()
  tmp1 <- bitr(tmp1,fromType = "ENTREZID",toType = 'SYMBOL',OrgDb = "org.Hs.eg.db") %>% as.data.frame()
  test <- tmp1[,2] %>% paste(.,collapse = '/')
  ke[num,10] <- test
}
write.csv(ke,file="kEGG.csv",row.names = F)
go <- data.frame(erich.go.BP)
a=1:110
for (i in a){
  num <- i
  tmp1 <- mf[num,8] %>% strsplit("/") %>% unlist()
  tmp1 <- bitr(tmp1,fromType = "ENTREZID",toType = 'SYMBOL',OrgDb = "org.Hs.eg.db") %>% as.data.frame()
  test <- tmp1[,2] %>% paste(.,collapse = '/')
  mf[num,10] <- test
}
write.csv(mf,file="MF_result.csv",row.names = F)

a=2:62
tmp1 <- ke[1,10] %>% strsplit("/") %>% unlist()
temp <- tmp1
for (i in a){
  num <- i
  tmp2 <- ke[num,10] %>% strsplit("/") %>% unlist()
  temp <- append(temp,tmp2)
}
data <- read.table(file,header = F)
temp1 <- as.tibble(data)
colnames(temp1) <- c("symbol","miRNA")
DEG.gene_symbol <- as.character(unique(data$V1))
DEG.entrez_id = mapIds(x = org.Hs.eg.db,keys = DEG.gene_symbol,keytype = "SYMBOL",column = "ENTREZID")
temp2 <- as.data.frame(DEG.entrez_id)
temp2$symbol <- rownames(temp2)
result <- full_join(temp1,temp2,by="symbol")
remove(temp1)
temp1 <- tibble(symbol=temp)
tt <- left_join(temp1,result,by="symbol")
temp <- tt[,-3]
write.table(temp,file=file3)
